<?php
// Define the path to the CSV file
$csvFile = 'BMP390_P1_P2.csv';

// Check if all required POST parameters are set
if (
    isset($_POST['t1']) &&
    isset($_POST['p1']) &&
    isset($_POST['t2']) &&
    isset($_POST['p2']) &&
    isset($_POST['timestamp'])
) {
    // Retrieve values
    $t1 = $_POST['t1'];
    $p1 = $_POST['p1'];
    $t2 = $_POST['t2'];
    $p2 = $_POST['p2'];
    $timestamp = $_POST['timestamp'];

    // Open the CSV file in append mode
    if ($fileHandle = fopen($csvFile, 'a')) {
        // Create an array with all values in desired order
        $data = array($timestamp, $t1, $p1, $t2, $p2);

        // Write to CSV
        if (fputcsv($fileHandle, $data) === false) {
            error_log('Error writing data to CSV file.');
        }

        fclose($fileHandle);
    } else {
        error_log('Error opening CSV file for writing.');
    }
} else {
    error_log('One or more POST parameters not set.');
}
?>
