<?php
// rx_TH.php: Receives POSTs from humidistat and appends to a CSV file

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Debug log
file_put_contents(__DIR__ . '/debug.log', date('Y-m-d H:i:s') . " POST: " . print_r($_POST, true) . "\n", FILE_APPEND);

// Set the CSV file path
$csv_file = __DIR__ . '/humidistat_data.csv';

// Handle CSV line POSTed as 'csv' variable
if (isset($_POST['csv'])) {
    $lines = preg_split('/\r?\n/', trim($_POST['csv']));
    $fp = fopen($csv_file, 'a');
    foreach ($lines as $line) {
        $line = trim($line);
        if ($line === '') continue;
        if (strpos($line, 'tempC_bmp') === 0 || strpos($line, 'timestamp') === 0) {
            // Header line
            fwrite($fp, "timestamp," . $line . "\n");
        } else {
            // Data line
            $fields = str_getcsv($line);
            array_unshift($fields, date('Y-m-d H:i:s'));
            fputcsv($fp, $fields);
        }
    }
    fclose($fp);
    header('Content-Type: application/json');
    echo json_encode(['status' => 'ok']);
    exit;
}

// Get POST data (with fallback for missing fields)
$timestamp     = isset($_POST['timestamp'])     ? $_POST['timestamp']     : date('Y-m-d H:i:s');
$tempC_bmp     = isset($_POST['tempC_bmp'])     ? $_POST['tempC_bmp']     : '';
$tempC_aht     = isset($_POST['tempC_aht'])     ? $_POST['tempC_aht']     : '';
$humidity      = isset($_POST['humidity'])      ? $_POST['humidity']      : '';
$pressure      = isset($_POST['pressure'])      ? $_POST['pressure']      : '';
$setpointC     = isset($_POST['setpointC'])     ? $_POST['setpointC']     : '';
$furnace       = isset($_POST['furnace'])       ? $_POST['furnace']       : '';
$dehumidifier  = isset($_POST['dehumidifier'])  ? $_POST['dehumidifier']  : '';
$control       = isset($_POST['control'])       ? $_POST['control']       : '';

// Prepare row as array
$row = [
    $timestamp,
    $tempC_bmp,
    $tempC_aht,
    $humidity,
    $pressure,
    $setpointC,
    $furnace,
    $dehumidifier,
    $control
];

// If file does not exist, write header
if (!file_exists($csv_file)) {
    $header = [
        'timestamp',
        'tempC_bmp',
        'tempC_aht',
        'humidity',
        'pressure',
        'setpointC',
        'furnace',
        'dehumidifier',
        'control'
    ];
    $fp = fopen($csv_file, 'a');
    fputcsv($fp, $header);
    fclose($fp);
}

// Append row to CSV
$fp = fopen($csv_file, 'a');
fputcsv($fp, $row);
fclose($fp);

// Respond with success
header('Content-Type: application/json');
echo json_encode(['status' => 'ok']);
